<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommonFieldsTable extends Migration {

	public function up()
	{
		Schema::create('common_fields', function(Blueprint $table) {
			$table->increments('id');
			$table->string('id_rel', 10);
			$table->string('tabla', 50);
			$table->text('title')->nullable();
			$table->text('description')->nullable();
			$table->text('title_tc')->nullable();
			$table->text('title_og')->nullable();
			$table->text('description_tc')->nullable();
			$table->text('description_og')->nullable();
			$table->string('robots', 100);
			$table->text('h1')->nullable();
			$table->string('canonical', 255)->nullable();
			$table->text('nombre')->nullable();
			$table->mediumText('descripcion_corta')->nullable();
			$table->longText('descripcion_larga')->nullable();
			$table->string('foto_principal', 255)->nullable();
			$table->string('miniatura', 255);
			$table->text('slug')->nullable();
			$table->integer('orden')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('common_fields');
	}
}