<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration {

	public function up()
	{
		Schema::create('students', function(Blueprint $table) {
			$table->increments('id');
			$table->string('full_name', 200);
			$table->string('birthday');
			$table->integer('mobile');
			$table->integer('phone');
			$table->integer('nationality_id');
			$table->integer('national_identity');
			$table->enum('blood_type', array(''));
			$table->enum('guardian_relation', array(''));
			$table->string('guardian_name', 20);
			$table->string('guardian_mobile');
			$table->integer('guardian_phone');
			$table->string('address');
			$table->enum('qualification', array(''));
			$table->string('Quran_course');
			$table->integer('Quran_count');
			$table->enum('status', array(''));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('students');
	}
}