<?php

namespace users;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Users extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function farms()
    {
        return $this->hasOne('Farm', 'farm_id');
    }

    public function cow()
    {
        return $this->hasMany('Cow', 'cow_id');
    }

}