<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Clinics extends Model 
{

    protected $table = 'clinics';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'logo', 'latitude', 'longitude', 'adress_en', 'adress_ar', 'rating', 'user_id', 'fees', 'waiting_time', 'email', 'phone');

    public function user()
    {
        return $this->belongsTo('Clinics', 'user_id');
    }

    public function specialities()
    {
        return $this->hasMany('Provider_specialities', 'clinic_id');
    }

}