<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Rate extends Eloquent {

	protected $table = 'rate';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('booking_id', 'q1', 'q2', 'q3', 'q4', 'review');

	public function booking()
	{
		return $this->belongsTo('Bookings', 'booking_id');
	}

}