<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Discounts extends Model 
{

    protected $table = 'discounts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('code', 'name', 'is_percent', 'amount', 'clinic_id', 'doctor_id', 'uses', 'max_uses', 'start_at', 'expire_at', 'user_id');

    public function clinic()
    {
        return $this->belongsTo('Clinics', 'clinic_id');
    }

    public function doctor()
    {
        return $this->belongsTo('Doctors', 'doctor_id');
    }

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

}