<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Provider_specialities extends Model 
{

    protected $table = 'provider_specialities';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('clinic_id', 'doctor_id', 'specilaty_id');

    public function clinic()
    {
        return $this->belongsTo('Clinics', 'clinic_id');
    }

    public function doctor()
    {
        return $this->belongsTo('Doctors', 'doctor_id');
    }

    public function speciality()
    {
        return $this->belongsTo('Specialities', 'speciality_id');
    }

}