<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email')->nullable();
			$table->string('company')->nullable();
			$table->string('mobile')->nullable();
			$table->string('country')->nullable();
			$table->string('city')->nullable();
			$table->string('product_category')->nullable();
			$table->string('product')->nullable();
			$table->integer('quantity')->nullable();
			$table->longText('message')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}