<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTechnicalsupportsTable extends Migration {

	public function up()
	{
		Schema::create('technicalsupports', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('slug');
			$table->integer('parent_id')->nullable();
			$table->integer('type');
			$table->tinyInteger('product_guide')->nullable()->default('0');
			$table->integer('product_cat')->nullable()->default('0');
			$table->tinyInteger('coa_request')->nullable()->default('0');
			$table->tinyInteger('discuss_expert')->nullable()->default('0');
			$table->string('attachment')->nullable();
			$table->string('attachment2')->nullable();
			$table->string('guide_link')->nullable();
			$table->string('catalogue_link')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('technicalsupports');
	}
}