<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('news', 'article', 'report', 'service'));
			$table->string('slug');
			$table->string('title', 255);
			$table->string('excerpt', 255);
			$table->boolean('pushed');
			$table->string('url_image', 255);
			$table->integer('estimated_read_time')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}