<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsuarioTable extends Migration {

	public function up()
	{
		Schema::create('Usuario', function(Blueprint $table) {
			$table->increments('idUsuario');
			$table->string('nombre', 50);
			$table->string('apellido', 50);
			$table->string('noLicencia', 25)->nullable();
			$table->date('vencimientoLicencia')->nullable();
			$table->string('cargo', 50);
			$table->string('telefono', 20)->nullable();
			$table->string('correo', 100)->nullable();
			$table->integer('idCatUsuario')->unsigned();
			$table->string('direccion', 150)->nullable();
			$table->smallInteger('codigoPostal')->nullable();
			$table->string('estatus', 10)->default('activo');
			$table->string('usuario', 50)->nullable();
			$table->string('password', 50)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('Usuario');
	}
}