<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFacilityPackagesTable extends Migration {

	public function up()
	{
		Schema::create('facility_packages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('facility_id')->unsigned()->index();
			$table->integer('package_id')->unsigned()->index();
			$table->date('start_date');
			$table->date('end_date');
			$table->decimal('price');
			$table->integer('contract_file_id')->unsigned()->nullable();
			$table->string('status');
			$table->date('created_at');
			$table->string('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('facility_packages');
	}
}