<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('notifiable_type')->index();
			$table->bigInteger('notifiable_id')->index();
			$table->string('channel');
			$table->string('title');
			$table->text('message');
			$table->timestamp('read_at')->nullable();
			$table->date('created_at');
			$table->date('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}