<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketItemsTable extends Migration {

	public function up()
	{
		Schema::create('ticket_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('ticket_version_id')->unsigned();
			$table->integer('question_id')->unsigned();
			$table->integer('violation_id')->unsigned();
			$table->string('priority');
			$table->string('status');
			$table->text('corrective_action')->nullable();
			$table->text('notes')->nullable();
			$table->date('created_at');
			$table->date('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('ticket_items');
	}
}