<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_roles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_permissions', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('facilities', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('facilities', function(Blueprint $table) {
			$table->foreign('zone_id')->references('id')->on('zones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inspector_profiles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('inspector_profiles', function(Blueprint $table) {
			$table->foreign('zone_id')->references('id')->on('zones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('package_services', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('package_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('facility_packages', function(Blueprint $table) {
			$table->foreign('facility_id')->references('id')->on('facilities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('facility_packages', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('facility_packages', function(Blueprint $table) {
			$table->foreign('contract_file_id')->references('id')->on('attachments')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('facility_services', function(Blueprint $table) {
			$table->foreign('facility_package_id')->references('id')->on('facility_packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('facility_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('applications', function(Blueprint $table) {
			$table->foreign('facility_id')->references('id')->on('facilities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('applications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('applications', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('application_documents', function(Blueprint $table) {
			$table->foreign('application_id')->references('id')->on('applications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('application_documents', function(Blueprint $table) {
			$table->foreign('attachment_id')->references('id')->on('attachments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('report_templates', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('template_versions', function(Blueprint $table) {
			$table->foreign('report_template_id')->references('id')->on('report_templates')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('question_bank', function(Blueprint $table) {
			$table->foreign('violation_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('question_options', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('question_bank')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('template_questions', function(Blueprint $table) {
			$table->foreign('template_version_id')->references('id')->on('template_versions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('template_questions', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('question_bank')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('facility_id')->references('id')->on('facilities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('facility_service_id')->references('id')->on('facility_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('inspector_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('supervisor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('template_version_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('current_status_id')->references('id')->on('appointment_status_history')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('report_submissions', function(Blueprint $table) {
			$table->foreign('appointment_id')->references('id')->on('appointments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('report_submissions', function(Blueprint $table) {
			$table->foreign('inspector_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('report_submissions', function(Blueprint $table) {
			$table->foreign('verified_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('report_submission_id')->references('id')->on('report_submissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('template_question_id')->references('id')->on('template_versions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('facility_id')->references('id')->on('facilities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('appointment_id')->references('id')->on('appointments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ticket_versions', function(Blueprint $table) {
			$table->foreign('ticket_id')->references('id')->on('tickets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ticket_items', function(Blueprint $table) {
			$table->foreign('ticket_version_id')->references('id')->on('ticket_versions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ticket_items', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('question_bank')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ticket_items', function(Blueprint $table) {
			$table->foreign('violation_id')->references('id')->on('violations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('attachment_links', function(Blueprint $table) {
			$table->foreign('attachment_id')->references('id')->on('attachments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('kitchens', function(Blueprint $table) {
			$table->foreign('facility_id')->references('id')->on('facilities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('kitchens', function(Blueprint $table) {
			$table->foreign('zone_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('report_sections', function(Blueprint $table) {
			$table->foreign('template_version_id')->references('id')->on('template_versions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('requirements', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('requirements', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('facility_requirement_submissions', function(Blueprint $table) {
			$table->foreign('facility_id')->references('id')->on('facilities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('facility_requirement_submissions', function(Blueprint $table) {
			$table->foreign('requirement_id')->references('id')->on('requirements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('facility_requirement_submissions', function(Blueprint $table) {
			$table->foreign('attachment_id')->references('id')->on('attachments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('facility_requirement_submissions', function(Blueprint $table) {
			$table->foreign('reviewed_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lookup_values', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('appointment_status_history', function(Blueprint $table) {
			$table->foreign('appointment_id')->references('id')->on('appointments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('appointment_status_history', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('lookup_values')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointment_status_history', function(Blueprint $table) {
			$table->foreign('changed_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user_roles', function(Blueprint $table) {
			$table->dropForeign('user_roles_user_id_foreign');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->dropForeign('user_roles_role_id_foreign');
		});
		Schema::table('role_permissions', function(Blueprint $table) {
			$table->dropForeign('role_permissions_role_id_foreign');
		});
		Schema::table('role_permissions', function(Blueprint $table) {
			$table->dropForeign('role_permissions_permission_id_foreign');
		});
		Schema::table('facilities', function(Blueprint $table) {
			$table->dropForeign('facilities_user_id_foreign');
		});
		Schema::table('facilities', function(Blueprint $table) {
			$table->dropForeign('facilities_zone_id_foreign');
		});
		Schema::table('inspector_profiles', function(Blueprint $table) {
			$table->dropForeign('inspector_profiles_user_id_foreign');
		});
		Schema::table('inspector_profiles', function(Blueprint $table) {
			$table->dropForeign('inspector_profiles_zone_id_foreign');
		});
		Schema::table('package_services', function(Blueprint $table) {
			$table->dropForeign('package_services_package_id_foreign');
		});
		Schema::table('package_services', function(Blueprint $table) {
			$table->dropForeign('package_services_service_id_foreign');
		});
		Schema::table('facility_packages', function(Blueprint $table) {
			$table->dropForeign('facility_packages_facility_id_foreign');
		});
		Schema::table('facility_packages', function(Blueprint $table) {
			$table->dropForeign('facility_packages_package_id_foreign');
		});
		Schema::table('facility_packages', function(Blueprint $table) {
			$table->dropForeign('facility_packages_contract_file_id_foreign');
		});
		Schema::table('facility_services', function(Blueprint $table) {
			$table->dropForeign('facility_services_facility_package_id_foreign');
		});
		Schema::table('facility_services', function(Blueprint $table) {
			$table->dropForeign('facility_services_service_id_foreign');
		});
		Schema::table('applications', function(Blueprint $table) {
			$table->dropForeign('applications_facility_id_foreign');
		});
		Schema::table('applications', function(Blueprint $table) {
			$table->dropForeign('applications_user_id_foreign');
		});
		Schema::table('applications', function(Blueprint $table) {
			$table->dropForeign('applications_package_id_foreign');
		});
		Schema::table('application_documents', function(Blueprint $table) {
			$table->dropForeign('application_documents_application_id_foreign');
		});
		Schema::table('application_documents', function(Blueprint $table) {
			$table->dropForeign('application_documents_attachment_id_foreign');
		});
		Schema::table('report_templates', function(Blueprint $table) {
			$table->dropForeign('report_templates_service_id_foreign');
		});
		Schema::table('template_versions', function(Blueprint $table) {
			$table->dropForeign('template_versions_report_template_id_foreign');
		});
		Schema::table('question_bank', function(Blueprint $table) {
			$table->dropForeign('question_bank_violation_id_foreign');
		});
		Schema::table('question_options', function(Blueprint $table) {
			$table->dropForeign('question_options_question_id_foreign');
		});
		Schema::table('template_questions', function(Blueprint $table) {
			$table->dropForeign('template_questions_template_version_id_foreign');
		});
		Schema::table('template_questions', function(Blueprint $table) {
			$table->dropForeign('template_questions_question_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_facility_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_facility_service_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_inspector_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_supervisor_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_template_version_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_current_status_id_foreign');
		});
		Schema::table('report_submissions', function(Blueprint $table) {
			$table->dropForeign('report_submissions_appointment_id_foreign');
		});
		Schema::table('report_submissions', function(Blueprint $table) {
			$table->dropForeign('report_submissions_inspector_id_foreign');
		});
		Schema::table('report_submissions', function(Blueprint $table) {
			$table->dropForeign('report_submissions_verified_by_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_report_submission_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_template_question_id_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_facility_id_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_appointment_id_foreign');
		});
		Schema::table('ticket_versions', function(Blueprint $table) {
			$table->dropForeign('ticket_versions_ticket_id_foreign');
		});
		Schema::table('ticket_items', function(Blueprint $table) {
			$table->dropForeign('ticket_items_ticket_version_id_foreign');
		});
		Schema::table('ticket_items', function(Blueprint $table) {
			$table->dropForeign('ticket_items_question_id_foreign');
		});
		Schema::table('ticket_items', function(Blueprint $table) {
			$table->dropForeign('ticket_items_violation_id_foreign');
		});
		Schema::table('attachment_links', function(Blueprint $table) {
			$table->dropForeign('attachment_links_attachment_id_foreign');
		});
		Schema::table('kitchens', function(Blueprint $table) {
			$table->dropForeign('kitchens_facility_id_foreign');
		});
		Schema::table('kitchens', function(Blueprint $table) {
			$table->dropForeign('kitchens_zone_id_foreign');
		});
		Schema::table('report_sections', function(Blueprint $table) {
			$table->dropForeign('report_sections_template_version_id_foreign');
		});
		Schema::table('requirements', function(Blueprint $table) {
			$table->dropForeign('requirements_package_id_foreign');
		});
		Schema::table('requirements', function(Blueprint $table) {
			$table->dropForeign('requirements_service_id_foreign');
		});
		Schema::table('facility_requirement_submissions', function(Blueprint $table) {
			$table->dropForeign('facility_requirement_submissions_facility_id_foreign');
		});
		Schema::table('facility_requirement_submissions', function(Blueprint $table) {
			$table->dropForeign('facility_requirement_submissions_requirement_id_foreign');
		});
		Schema::table('facility_requirement_submissions', function(Blueprint $table) {
			$table->dropForeign('facility_requirement_submissions_attachment_id_foreign');
		});
		Schema::table('facility_requirement_submissions', function(Blueprint $table) {
			$table->dropForeign('facility_requirement_submissions_reviewed_by_foreign');
		});
		Schema::table('lookup_values', function(Blueprint $table) {
			$table->dropForeign('lookup_values_group_id_foreign');
		});
		Schema::table('appointment_status_history', function(Blueprint $table) {
			$table->dropForeign('appointment_status_history_appointment_id_foreign');
		});
		Schema::table('appointment_status_history', function(Blueprint $table) {
			$table->dropForeign('appointment_status_history_status_id_foreign');
		});
		Schema::table('appointment_status_history', function(Blueprint $table) {
			$table->dropForeign('appointment_status_history_changed_by_foreign');
		});
	}
}