<?php

namespace appointments;

class Appointments extends Eloquent {

	protected $table = 'appointments';
	public $timestamps = true;

	public function facility()
	{
		return $this->belongsTo('Facilities');
	}

	public function facilityService()
	{
		return $this->belongsTo('Facility_services');
	}

	public function inspector()
	{
		return $this->belongsTo('Users', 'inspector_id');
	}

	public function supervisor()
	{
		return $this->belongsTo('Users', 'supervisor_id');
	}

	public function templateVersion()
	{
		return $this->belongsTo('Template_versions');
	}

	public function reportSubmissions()
	{
		return $this->hasMany('Report_submissions');
	}

	public function kitchen()
	{
		return $this->belongsTo('Kitchens');
	}

	public function statuses()
	{
		return $this->hasMany('Appointment_status_history');
	}

}