<?php

class Users extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function role()
	{
		return $this->belongsTo('Roles');
	}

	public function facilities()
	{
		return $this->belongsToMany('Facilities', 'facility_users');
	}

	public function roles()
	{
		return $this->belongsToMany('User_roles', 'user_roles');
	}

	public function ownedFacilities()
	{
		return $this->hasMany('Facilities', 'owner_id');
	}

	public function inspectorProfile()
	{
		return $this->hasOne('Inspector_profiles', 'user_id');
	}

	public function applications()
	{
		return $this->hasMany('Applications', 'user_id');
	}

	public function reportSubmissions()
	{
		return $this->hasMany('Report_submissions', 'inspector_id');
	}

	public function notifications()
	{
		return $this->morphMany('Notifications', 'notifiable_id');
	}

	public function attachments()
	{
		return $this->morphMany('Attachments', 'attachable_id');
	}

}