<?php

namespace report_submissions;

use Illuminate\Database\Eloquent\Model;

class Report_submissions extends Model 
{

    protected $table = 'report_submissions';
    public $timestamps = true;

    public function attachments()
    {
        return $this->morphMany('Attachment_links');
    }

    public function answers()
    {
        return $this->hasMany('Answers');
    }

    public function appointment()
    {
        return $this->belongsTo('Appointments');
    }

    public function Kitchen()
    {
        return $this->belongsTo('Kitchens');
    }

    public function verifier()
    {
        return $this->belongsTo('Users', 'verified_by');
    }

}