<?php

namespace users;

use Illuminate\Database\Eloquent\Model;

class Roles extends Model 
{

    protected $table = 'roles';
    public $timestamps = true;

    public function users()
    {
        return $this->hasMany('Users', 'role_id');
    }

    public function permissions()
    {
        return $this->belongsToMany('Permissions', 'role_permissions');
    }

    public function usersPivot()
    {
        return $this->belongsToMany('User_roles', 'user_roles');
    }

}