<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionBankTable extends Migration {

	public function up()
	{
		Schema::create('question_bank', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->text('text');
			$table->string('type');
			$table->integer('weight')->default('1');
			$table->integer('violation_id')->unsigned()->nullable();
			$table->text('default_corrective_action')->nullable();
			$table->boolean('requires_attachment');
			$table->date('created_at');
			$table->date('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('question_bank');
	}
}