<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTankingsTable extends Migration {

	public function up()
	{
		Schema::create('tankings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('car_id')->unsigned()->index();
			$table->datetime('date')->nullable();
			$table->mediumInteger('milage');
			$table->mediumInteger('price');
			$table->string('product')->nullable();
			$table->decimal('quantity')->nullable();
			$table->decimal('unit_price')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tankings');
	}
}