<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEstateHousesTable extends Migration {

	public function up()
	{
		Schema::create('estate_houses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('estate_id');
			$table->integer('construction_area_type_id');
			$table->string('total');
			$table->string('total_sold');
			$table->string('sold_number');
			$table->string('land_type_id');
			$table->string('land_area');
			$table->string('land_area_type_id');
			$table->string('architecture_no');
			$table->string('urban_plan_id');
			$table->string('aisle_area');
			$table->string('high_voltage_line_area');
			$table->string('slope_area');
			$table->string('out_basement_area');
			$table->string('use_area_id');
			$table->string('driveway_area');
			$table->string('building_coverage');
			$table->string('share_enumerator');
			$table->string('share_denominator');
			$table->string('water_service_id');
			$table->string('sewage_id');
			$table->string('gas_id');
			$table->string('drainage_id');
			$table->string('is_all_electric');
			$table->string('equipment_remark');
			$table->string('total_month_for_rent');
			$table->string('total_year_for_rent');
			$table->string('floor_area_ratio');
			$table->datetime('built_at');
			$table->string('completion_status_id');
			$table->string('room_status_id');
			$table->string('contact_road_status_id');
			$table->string('house_parking_lot_id');
			$table->string('total_cars');
			$table->string('is_car_base');
			$table->string('is_car_port');
			$table->string('is_parking_built_in');
			$table->string('is_parking_underground');
			$table->string('parking_area');
			$table->string('is_parking_in_building');
			$table->string('building_standard_type_id');
			$table->string('building_standard_permission_reason');
			$table->string('flat_35_id');
			$table->string('notice_ids');
		});
	}

	public function down()
	{
		Schema::drop('estate_houses');
	}
}