<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEstateStationsTable extends Migration {

	public function up()
	{
		Schema::create('estate_stations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('estate_id')->unsigned();
			$table->integer('station_id');
			$table->integer('time_walk');
			$table->integer('distance_walk');
			$table->string('distance_by_car');
			$table->integer('time_station_to_bus');
			$table->string('bus_stop_name');
			$table->string('time_walk_to_bus');
			$table->datetime('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('estate_stations');
	}
}