<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTpaProviderServiceTable extends Migration {

	public function up()
	{
		Schema::create('tpa_provider_service', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->integer('provider_id')->unsigned();
			$table->integer('service_type_id')->unsigned();
			$table->string('details');
			$table->string('image');
			$table->double('price')->default('0');
			$table->integer('currency_id')->unsigned();
			$table->integer('invoice_payment_term_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('tpa_provider_service');
	}
}