<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTpaVesselTable extends Migration {

	public function up()
	{
		Schema::create('tpa_vessel', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->integer('company_id')->unsigned();
			$table->string('name');
			$table->string('imo_number');
			$table->integer('vessel_type_id');
			$table->string('nmsi_number');
			$table->date('built_date');
			$table->string('registred_country');
			$table->double('gross_tonnage');
			$table->double('summer_dwt');
			$table->date('pcsopep');
			$table->date('derrating');
		});
	}

	public function down()
	{
		Schema::drop('tpa_vessel');
	}
}