<?php

namespace App;

class Cliente extends Eloquent {

	protected $table = 'clientes';
	public $timestamps = false;

	public function patio()
	{
		return $this->hasMany('Patio', 'id_cliente', 'id_cliente');
	}

	public function choferes()
	{
		return $this->hasMany('App\Chofer', 'id_cliente', 'id_cliente');
	}

	public function vehiculos()
	{
		return $this->hasMany('App\VehiculosInternos', 'id_cliente', 'id_cliente');
	}

	public function tractores()
	{
		return $this->hasMany('App\Tractor', 'id_cliente', 'id_cliente');
	}

	public function cajas()
	{
		return $this->hasMany('App\Caja', 'id_cliente', 'id_cliente');
	}

	public function tamanoCaja()
	{
		return $this->hasMany('App\TamanoCaja', 'id_cliente', 'id_cliente');
	}

	public function status()
	{
		return $this->hasMany('App\Status', 'id_cliente', 'id_cliente');
	}

	public function tipoCaja()
	{
		return $this->hasMany('App\TipoCaja', 'id_cliente', 'id_cliente');
	}

	public function tipoVehiculo()
	{
		return $this->hasMany('App\TipoVehiculo', 'id_cliente', 'id_cliente');
	}

	public function usuarios()
	{
		return $this->hasMany('App\Usuario', 'id_usuario', 'id_usuario_registro');
	}

}