<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('funds', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('members', function(Blueprint $table) {
			$table->foreign('fund_id')->references('id')->on('funds')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('members', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('superTransactions', function(Blueprint $table) {
			$table->foreign('member_id')->references('id')->on('members')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('superTransactions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pensionTransactions', function(Blueprint $table) {
			$table->foreign('member_id')->references('id')->on('members')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('pensionTransactions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('fund_id')->references('id')->on('funds')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('funds', function(Blueprint $table) {
			$table->dropForeign('funds_user_id_foreign');
		});
		Schema::table('members', function(Blueprint $table) {
			$table->dropForeign('members_fund_id_foreign');
		});
		Schema::table('members', function(Blueprint $table) {
			$table->dropForeign('members_user_id_foreign');
		});
		Schema::table('superTransactions', function(Blueprint $table) {
			$table->dropForeign('superTransactions_member_id_foreign');
		});
		Schema::table('superTransactions', function(Blueprint $table) {
			$table->dropForeign('superTransactions_user_id_foreign');
		});
		Schema::table('pensionTransactions', function(Blueprint $table) {
			$table->dropForeign('pensionTransactions_member_id_foreign');
		});
		Schema::table('pensionTransactions', function(Blueprint $table) {
			$table->dropForeign('pensionTransactions_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_fund_id_foreign');
		});
	}
}