<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Question extends Eloquent {

	protected $table = 'questions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function questionType()
	{
		return $this->hasOne('QuizType');
	}

	public function questionChoices()
	{
		return $this->hasMany('QuestionChoices');
	}

	public function questionTableVariables()
	{
		return $this->hasMany('QuestionTalbleVariables');
	}

}