<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class QuizUser extends Eloquent {

	protected $table = 'quiz_user';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function quiz()
	{
		return $this->hasOne('Quiz');
	}

	public function user()
	{
		return $this->hasOne('User');
	}

	public function userQuentionAnswers()
	{
		return $this->hasMany('UserQuestionAnswer');
	}

}