<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdsTable extends Migration {

	public function up()
	{
		Schema::create('ads', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->json('type_configs');
			$table->string('skippable');
			$table->string('on_click');
			$table->string('name');
			$table->integer('ad_group_id')->unsigned();
			$table->enum('status', array(''));
			$table->enum('type', array('VAST_LINEAR', 'VAST_NONLINEAR', 'VAST_WRAPPER_REDIRECT', 'BANNER_IMAGE', 'BANNER_3RDPARTY', 'BANNER_HTML5', 'BANNER_VIDEO', 'BANNER_APARAT', 'BANNER_VASTTAG'));
			$table->integer('show_chance_percentage');
		});
	}

	public function down()
	{
		Schema::drop('ads');
	}
}