<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlayersTable extends Migration {

	public function up()
	{
		Schema::create('players', function(Blueprint $table) {
			$table->increments('id', true);
			$table->string('name')->unique();
			$table->bigInteger('xp')->unsigned()->default('0');
			$table->bigInteger('gold')->unsigned()->default('0');
			$table->boolean('alive')->default(1);
			$table->integer('attribute_points')->unsigned()->default('10');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('players');
	}
}