<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTableTable extends Migration {

	public function up()
	{
		Schema::create('items_table', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->integer('category_id')->unsigned();
			$table->string('name', 64);
			$table->integer('price');
			$table->string('image', 64);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('items_table');
	}
}