<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCadeauxTable extends Migration {

	public function up()
	{
		Schema::create('cadeaux', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('invite_id')->unsigned()->nullable();
			$table->string('slug', 255)->nullable();
			$table->string('key_pay_api', 255)->nullable();
			$table->string('montant', 255)->nullable();
			$table->string('received_amount', 225)->nullable();
			$table->string('nom', 255)->nullable();
			$table->string('devise', 255)->nullable();
			$table->string('methode', 255)->nullable();
			$table->string('statut', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('cadeaux');
	}
}