<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConfigsTable extends Migration {

	public function up()
	{
		Schema::create('configs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('global_admin_id')->unsigned()->nullable();
			$table->string('slug', 255)->nullable();
			$table->text('texte_spontane')->nullable();
			$table->string('prix', 10)->nullable();
			$table->integer('mois_avant')->nullable();
			$table->integer('plus_mois_avant')->nullable();
			$table->integer('prix_plus_mois_avant')->nullable();
			$table->integer('mois_apres')->nullable();
			$table->integer('plus_mois_apres')->nullable();
			$table->integer('prix_plus_mois_apres')->nullable();
			$table->string('infini_mois_apres', 10)->nullable();
			$table->integer('admin_forme')->nullable();
			$table->integer('plus_admin_forme')->nullable();
			$table->integer('prix_plus_admin_forme')->nullable();
			$table->string('infini_admin_forme', 10)->nullable();
			$table->integer('ceremonie_max')->nullable();
			$table->integer('plus_ceremonie_max')->nullable();
			$table->integer('prix_plus_ceremonie_max')->nullable();
			$table->string('infini_ceremonie_max', 10)->nullable();
			$table->integer('invite_max')->nullable();
			$table->integer('plus_invite_max')->nullable();
			$table->integer('prix_plus_invite_max')->nullable();
			$table->string('infini_invite_max', 10)->nullable();
			$table->integer('photo_max')->nullable();
			$table->integer('plus_photo_max')->nullable();
			$table->integer('prix_plus_photo_max')->nullable();
			$table->string('infini_photo_max', 10)->nullable();
			$table->integer('cagnotte_max')->nullable();
			$table->integer('plus_cagnotte_max')->nullable();
			$table->integer('prix_plus_cagnotte_max')->nullable();
			$table->string('infini_cagnotte_max', 10)->nullable();
			$table->string('num_vert', 255)->nullable();
			$table->string('statut', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('configs');
	}
}