<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEvenementsTable extends Migration {

	public function up()
	{
		Schema::create('evenements', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('defaultceremonie_id')->unsigned()->nullable();
			$table->string('slug', 255)->nullable();
			$table->string('button_qr_code', 10)->nullable()->default('0');
			$table->string('image_qr_code', 255)->nullable();
			$table->string('menu_pdf', 255)->nullable();
			$table->string('nom', 255)->nullable();
			$table->string('nom_madame', 255)->nullable();
			$table->string('nom_monsieur', 255)->nullable();
			$table->datetime('date')->nullable();
			$table->datetime('base_date_event')->nullable();
			$table->datetime('date_fermeture_reponse')->nullable();
			$table->string('email', 255)->nullable();
			$table->text('histoire')->nullable();
			$table->string('show_cagnotte', 10)->default('0');
			$table->string('pk_pay', 255)->nullable();
			$table->string('sk_pay', 255)->nullable();
			$table->text('apropos_madame')->nullable();
			$table->text('apropos_monsieur')->nullable();
			$table->string('invite_accompagner', 10)->nullable()->default('0');
			$table->text('texte_billet')->nullable();
			$table->text('texte_cagnotte')->nullable();
			$table->text('texte_envoi_invitation')->nullable();
			$table->text('texte_spontane')->nullable();
			$table->integer('mois_avant')->nullable();
			$table->integer('mois_apres')->nullable();
			$table->integer('admin_forme')->nullable();
			$table->integer('ceremonie_max')->nullable();
			$table->integer('invite_max')->nullable();
			$table->integer('photo_max')->nullable();
			$table->integer('cagnotte_max')->nullable();
			$table->string('domaine', 255)->nullable();
			$table->string('force_visibility', 10)->nullable()->default('0');
			$table->string('num_vert', 255)->nullable();
			$table->string('statut', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('evenements');
	}
}