<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVersementsTable extends Migration {

	public function up()
	{
		Schema::create('versements', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('slug', 255)->nullable();
			$table->integer('evenement_id')->unsigned()->nullable();
			$table->string('prix', 10)->nullable();
			$table->integer('mois_avant')->nullable();
			$table->integer('mois_apres')->nullable();
			$table->integer('admin_forme')->nullable();
			$table->integer('ceremonie_max')->nullable();
			$table->integer('invite_max')->nullable();
			$table->integer('photo_max')->nullable();
			$table->integer('cagnotte_max')->nullable();
			$table->string('domaine', 255)->nullable();
			$table->string('statut', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('versements');
	}
}