<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Posts extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('posted_by', 'contents', 'image', 'videos', 'like_count', 'comment_count', 'share_count', 'type', 'shared_by', 'status');
	protected $visible = array('posted_by', 'contents', 'image', 'videos', 'like_count', 'comment_count', 'share_count', 'type', 'shared_by', 'status');

	public function postedBy()
	{
		return $this->belongsTo('App\User');
	}

	public function getLikes()
	{
		return $this->hasMany('App\PostLike', 'post_id');
	}

	public function getShares()
	{
		return $this->hasMany('App\PostsShares', 'post_id');
	}

	public function getComments()
	{
		return $this->hasMany('App\PostsComment', 'post_id');
	}

	public function sharedBy()
	{
		return $this->belongsTo('App\User', 'shared_by');
	}

}