<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ItemReservation extends Eloquent {

	protected $table = 'item_reservation';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('reservation_id', 'item_id', 'created_by', 'updated_by');

	public function reservations()
	{
		return $this->hasMany('App\Models\Reservation', 'reservation_id');
	}

	public function items()
	{
		return $this->hasMany('App\Models\Item', 'item_id');
	}

}