<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionTable extends Migration {

	public function up()
	{
		Schema::create('transaction', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->double('amount')->default('0');
			$table->integer('client_id')->nullable();
			$table->integer('container_id')->nullable();
			$table->integer('account_id')->nullable();
			$table->enum('currency', array('aed', 'mru'))->nullable();
			$table->double('balance_before')->nullable()->default('0');
			$table->double('balance_after')->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('transaction');
	}
}