<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('resumes', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('resumes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('educations', function(Blueprint $table) {
			$table->foreign('resume_id')->references('id')->on('resumes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('educations', function(Blueprint $table) {
			$table->foreign('major_id')->references('id')->on('majors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('educations', function(Blueprint $table) {
			$table->foreign('school_id')->references('id')->on('schools')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('educations', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('educations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('work_experiences', function(Blueprint $table) {
			$table->foreign('resume_id')->references('id')->on('resumes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('work_experiences', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('work_experiences', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('work_experiences', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('work_experiences')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('schools', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('skillables', function(Blueprint $table) {
			$table->foreign('skill_id')->references('id')->on('skills')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('skillables', function(Blueprint $table) {
			$table->foreign('resume_id')->references('id')->on('resumes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('province_id')->references('id')->on('provinces')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('licenses', function(Blueprint $table) {
			$table->foreign('resume_id')->references('id')->on('resumes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('licenses', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('resumes', function(Blueprint $table) {
			$table->dropForeign('resumes_parent_id_foreign');
		});
		Schema::table('educations', function(Blueprint $table) {
			$table->dropForeign('educations_resume_id_foreign');
		});
		Schema::table('educations', function(Blueprint $table) {
			$table->dropForeign('educations_major_id_foreign');
		});
		Schema::table('educations', function(Blueprint $table) {
			$table->dropForeign('educations_school_id_foreign');
		});
		Schema::table('educations', function(Blueprint $table) {
			$table->dropForeign('educations_parent_id_foreign');
		});
		Schema::table('work_experiences', function(Blueprint $table) {
			$table->dropForeign('work_experiences_resume_id_foreign');
		});
		Schema::table('work_experiences', function(Blueprint $table) {
			$table->dropForeign('work_experiences_company_id_foreign');
		});
		Schema::table('work_experiences', function(Blueprint $table) {
			$table->dropForeign('work_experiences_city_id_foreign');
		});
		Schema::table('work_experiences', function(Blueprint $table) {
			$table->dropForeign('work_experiences_parent_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_city_id_foreign');
		});
		Schema::table('schools', function(Blueprint $table) {
			$table->dropForeign('schools_city_id_foreign');
		});
		Schema::table('skillables', function(Blueprint $table) {
			$table->dropForeign('skillables_skill_id_foreign');
		});
		Schema::table('skillables', function(Blueprint $table) {
			$table->dropForeign('skillables_resume_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_province_id_foreign');
		});
		Schema::table('licenses', function(Blueprint $table) {
			$table->dropForeign('licenses_resume_id_foreign');
		});
		Schema::table('licenses', function(Blueprint $table) {
			$table->dropForeign('licenses_company_id_foreign');
		});
	}
}