<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('restaurant_id')->unsigned()->nullable();
			$table->bigInteger('from_user_id')->unsigned()->nullable()->default('null');
			$table->tinyInteger('stars')->nullable()->default('null');
			$table->text('content')->nullable()->default('null');
			$table->timestamps();
			$table->timestamp('read_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}