<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigInteger('id', true);
			$table->string('name', 255);
			$table->string('email', 255)->unique();
			$table->string('role', 25);
			$table->string('avatar', 250)->nullable();
			$table->timestamps();
			$table->timestamp('last_activity_at')->nullable();
			$table->timestamp('blocked_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}