<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users_meta', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('restaurants', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('restaurants_meta', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('from_user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('reviews_replies', function(Blueprint $table) {
			$table->foreign('review_id')->references('id')->on('reviews')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('restaurans_photos', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('subscriptions_plans')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('subscriptions_orders', function(Blueprint $table) {
			$table->foreign('subscription_id')->references('id')->on('subscriptions')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('contact', function(Blueprint $table) {
			$table->foreign('from_user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('stats', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('restaurans_cuisines', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('restaurans_cuisines', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('cuisine_types')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('lunches', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('lunches_courses_photos', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('lunches_dishes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('lunches_courses_photos', function(Blueprint $table) {
			$table->foreign('lunch_id')->references('id')->on('lunches')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('lunches_courses_photos', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('lunches_categories', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('config_langs')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('lunches_courses_lang', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('config_langs')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('lunches_courses_lang', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('lunches_dishes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('lunches_courses_lang', function(Blueprint $table) {
			$table->foreign('lunch_id')->references('id')->on('lunches')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('faq_lang', function(Blueprint $table) {
			$table->foreign('faq_id')->references('id')->on('faq')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('faq_lang', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('config_langs')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('lunch_id')->references('id')->on('lunches')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('cuisine_types_lang', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('cuisine_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cuisine_types_lang', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('config_langs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lunches_categories_lang', function(Blueprint $table) {
			$table->foreign('categ_id')->references('id')->on('lunches_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_fav_restaurants', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('users_fav_restaurants', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('users_internal_notes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('lunches_dishes', function(Blueprint $table) {
			$table->foreign('lunch_id')->references('id')->on('lunches')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('lunches_calendar', function(Blueprint $table) {
			$table->foreign('lunch_id')->references('id')->on('lunches')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('restaurant_opening_hours', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('users_meta', function(Blueprint $table) {
			$table->dropForeign('users_meta_user_id_foreign');
		});
		Schema::table('restaurants', function(Blueprint $table) {
			$table->dropForeign('restaurants_user_id_foreign');
		});
		Schema::table('restaurants_meta', function(Blueprint $table) {
			$table->dropForeign('restaurants_meta_restaurant_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_restaurant_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_from_user_id_foreign');
		});
		Schema::table('reviews_replies', function(Blueprint $table) {
			$table->dropForeign('reviews_replies_review_id_foreign');
		});
		Schema::table('restaurans_photos', function(Blueprint $table) {
			$table->dropForeign('restaurans_photos_restaurant_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_plan_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_user_id_foreign');
		});
		Schema::table('subscriptions_orders', function(Blueprint $table) {
			$table->dropForeign('subscriptions_orders_subscription_id_foreign');
		});
		Schema::table('contact', function(Blueprint $table) {
			$table->dropForeign('contact_from_user_id_foreign');
		});
		Schema::table('stats', function(Blueprint $table) {
			$table->dropForeign('stats_restaurant_id_foreign');
		});
		Schema::table('restaurans_cuisines', function(Blueprint $table) {
			$table->dropForeign('restaurans_cuisines_restaurant_id_foreign');
		});
		Schema::table('restaurans_cuisines', function(Blueprint $table) {
			$table->dropForeign('restaurans_cuisines_type_id_foreign');
		});
		Schema::table('lunches', function(Blueprint $table) {
			$table->dropForeign('lunches_restaurant_id_foreign');
		});
		Schema::table('lunches_courses_photos', function(Blueprint $table) {
			$table->dropForeign('lunches_courses_photos_course_id_foreign');
		});
		Schema::table('lunches_courses_photos', function(Blueprint $table) {
			$table->dropForeign('lunches_courses_photos_lunch_id_foreign');
		});
		Schema::table('lunches_courses_photos', function(Blueprint $table) {
			$table->dropForeign('lunches_courses_photos_restaurant_id_foreign');
		});
		Schema::table('lunches_categories', function(Blueprint $table) {
			$table->dropForeign('lunches_categories_lang_id_foreign');
		});
		Schema::table('lunches_courses_lang', function(Blueprint $table) {
			$table->dropForeign('lunches_courses_lang_lang_id_foreign');
		});
		Schema::table('lunches_courses_lang', function(Blueprint $table) {
			$table->dropForeign('lunches_courses_lang_course_id_foreign');
		});
		Schema::table('lunches_courses_lang', function(Blueprint $table) {
			$table->dropForeign('lunches_courses_lang_lunch_id_foreign');
		});
		Schema::table('faq_lang', function(Blueprint $table) {
			$table->dropForeign('faq_lang_faq_id_foreign');
		});
		Schema::table('faq_lang', function(Blueprint $table) {
			$table->dropForeign('faq_lang_lang_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_lunch_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_order_id_foreign');
		});
		Schema::table('cuisine_types_lang', function(Blueprint $table) {
			$table->dropForeign('cuisine_types_lang_type_id_foreign');
		});
		Schema::table('cuisine_types_lang', function(Blueprint $table) {
			$table->dropForeign('cuisine_types_lang_lang_id_foreign');
		});
		Schema::table('lunches_categories_lang', function(Blueprint $table) {
			$table->dropForeign('lunches_categories_lang_categ_id_foreign');
		});
		Schema::table('users_fav_restaurants', function(Blueprint $table) {
			$table->dropForeign('users_fav_restaurants_user_id_foreign');
		});
		Schema::table('users_fav_restaurants', function(Blueprint $table) {
			$table->dropForeign('users_fav_restaurants_restaurant_id_foreign');
		});
		Schema::table('users_internal_notes', function(Blueprint $table) {
			$table->dropForeign('users_internal_notes_user_id_foreign');
		});
		Schema::table('lunches_dishes', function(Blueprint $table) {
			$table->dropForeign('lunches_dishes_lunch_id_foreign');
		});
		Schema::table('lunches_calendar', function(Blueprint $table) {
			$table->dropForeign('lunches_calendar_lunch_id_foreign');
		});
		Schema::table('restaurant_opening_hours', function(Blueprint $table) {
			$table->dropForeign('restaurant_opening_hours_restaurant_id_foreign');
		});
	}
}