<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantsTable extends Migration {

	public function up()
	{
		Schema::create('restaurants', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->string('name', 200);
			$table->string('status', 25);
			$table->string('logo', 255)->nullable();
			$table->string('geo_lat', 25)->nullable();
			$table->string('geo_long', 25)->nullable();
			$table->text('address')->nullable();
			$table->tinyInteger('has_terrace')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('restaurants');
	}
}