<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->date('date');
			$table->decimal('amount');
			$table->string('country_id');
			$table->string('agent_id');
			$table->integer('adults');
			$table->integer('children')->nullable();
			$table->integer('infant')->nullable();
			$table->string('customer_name');
			$table->string('customer_contact_number');
			$table->string('customer_address')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}