<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('pricing_scheme', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('activities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Pricing', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('activities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Pricing', function(Blueprint $table) {
			$table->foreign('pricing_scheme_id')->references('id')->on('pricing_scheme')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activity_specs', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('activities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('pricing_scheme', function(Blueprint $table) {
			$table->dropForeign('pricing_scheme_activity_id_foreign');
		});
		Schema::table('Pricing', function(Blueprint $table) {
			$table->dropForeign('Pricing_activity_id_foreign');
		});
		Schema::table('Pricing', function(Blueprint $table) {
			$table->dropForeign('Pricing_pricing_scheme_id_foreign');
		});
		Schema::table('activity_specs', function(Blueprint $table) {
			$table->dropForeign('activity_specs_activity_id_foreign');
		});
	}
}