<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('page', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('page', function(Blueprint $table) {
			$table->foreign('page_type_id')->references('id')->on('page_type')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('page', function(Blueprint $table) {
			$table->foreign('template_id')->references('id')->on('template')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('page', function(Blueprint $table) {
			$table->foreign('parent')->references('id')->on('page')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('page', function(Blueprint $table) {
			$table->foreign('layout_id')->references('id')->on('layout')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('comment', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('page')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('page_type', function(Blueprint $table) {
			$table->foreign('layout_id')->references('id')->on('layout')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('page_meta', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('page')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('menu', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('page')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('widget', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('page')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('layout_widget', function(Blueprint $table) {
			$table->foreign('widget_id')->references('id')->on('widget')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('layout_widget', function(Blueprint $table) {
			$table->foreign('layout_id')->references('id')->on('layout')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('media_meta', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('media')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('media_page', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('media')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('media_page', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('page')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('user_meta', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('page', function(Blueprint $table) {
			$table->dropForeign('page_user_id_foreign');
		});
		Schema::table('page', function(Blueprint $table) {
			$table->dropForeign('page_page_type_id_foreign');
		});
		Schema::table('page', function(Blueprint $table) {
			$table->dropForeign('page_template_id_foreign');
		});
		Schema::table('page', function(Blueprint $table) {
			$table->dropForeign('page_parent_foreign');
		});
		Schema::table('page', function(Blueprint $table) {
			$table->dropForeign('page_layout_id_foreign');
		});
		Schema::table('comment', function(Blueprint $table) {
			$table->dropForeign('comment_page_id_foreign');
		});
		Schema::table('page_type', function(Blueprint $table) {
			$table->dropForeign('page_type_layout_id_foreign');
		});
		Schema::table('page_meta', function(Blueprint $table) {
			$table->dropForeign('page_meta_page_id_foreign');
		});
		Schema::table('menu', function(Blueprint $table) {
			$table->dropForeign('menu_page_id_foreign');
		});
		Schema::table('widget', function(Blueprint $table) {
			$table->dropForeign('widget_page_id_foreign');
		});
		Schema::table('layout_widget', function(Blueprint $table) {
			$table->dropForeign('layout_widget_widget_id_foreign');
		});
		Schema::table('layout_widget', function(Blueprint $table) {
			$table->dropForeign('layout_widget_layout_id_foreign');
		});
		Schema::table('media_meta', function(Blueprint $table) {
			$table->dropForeign('media_meta_media_id_foreign');
		});
		Schema::table('media_page', function(Blueprint $table) {
			$table->dropForeign('media_page_media_id_foreign');
		});
		Schema::table('media_page', function(Blueprint $table) {
			$table->dropForeign('media_page_page_id_foreign');
		});
		Schema::table('user_meta', function(Blueprint $table) {
			$table->dropForeign('user_meta_user_id_foreign');
		});
	}
}