<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLefSourceMappingTable extends Migration {

	public function up()
	{
		Schema::create('lef_source_mapping', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned();
			$table->integer('source_id')->unique()->unsigned();
			$table->string('system_rule');
			$table->string('source_rule');
			$table->string('qualification_rule');
			$table->string('ga_source_rule');
			$table->string('ga_medium_rule');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('lef_source_mapping');
	}
}