<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMyServicesTable extends Migration {

	public function up()
	{
		Schema::create('my_services', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code');
			$table->integer('sub_service_id')->unsigned();
			$table->string('customer_name');
			$table->string('customer_email');
			$table->string('customer_mobile');
			$table->string('foundation_name');
			$table->integer('foundation_type_id')->unsigned();
			$table->string('customer_message');
			$table->string('communication_suitable_time');
			$table->string('status');
			$table->text('rejection_reason');
			$table->string('price');
			$table->string('financial_advance');
			$table->string('advance_tax');
			$table->string('additional_tax');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('my_services');
	}
}