<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentHistoryTable extends Migration {

	public function up()
	{
		Schema::create('payment_history', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('company_id')->nullable();
			$table->integer('user_id')->nullable();
			$table->string('status')->nullable();
			$table->double('total')->nullable();
			$table->integer('payment_method_id')->nullable();
			$table->integer('order_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('payment_history');
	}
}